/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.balm.common.client.IconExport;
import net.blay09.mods.balm.common.config.ConfigJsonExport;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class BalmCommand {
    private static final class_2960 PERMISSION_BALM_DEV = class_2960.method_60655((String)"balm", (String)"command.balm.dev");
    private static final class_2960 PERMISSION_BALM_EXPORT_CONFIG = class_2960.method_60655((String)"balm", (String)"command.balm.export.config");
    private static final class_2960 PERMISSION_BALM_EXPORT_ICONS = class_2960.method_60655((String)"balm", (String)"command.balm.export.icons");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        BalmCommands.registerPermission(PERMISSION_BALM_DEV, 2);
        BalmCommands.registerPermission(PERMISSION_BALM_EXPORT_CONFIG, 4);
        BalmCommands.registerPermission(PERMISSION_BALM_EXPORT_ICONS, 4);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"balm").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dev").requires(BalmCommands.requirePermission(PERMISSION_BALM_DEV))).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            MinecraftServer server = source.method_9211();
            class_1928 gameRules = server.method_3767();
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19396)).method_20758(false, server);
            source.method_9226(() -> class_2561.method_43470((String)"Daylight cycle disabled"), true);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19406)).method_20758(false, server);
            source.method_9226(() -> class_2561.method_43470((String)"Weather cycle disabled"), true);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19389)).method_20758(true, server);
            source.method_9226(() -> class_2561.method_43470((String)"Keep Inventory enabled"), true);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_20637)).method_20758(false, server);
            source.method_9226(() -> class_2561.method_43470((String)"Insomnia disabled"), true);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19388)).method_20758(false, server);
            source.method_9226(() -> class_2561.method_43470((String)"Mob Griefing disabled"), true);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_21832)).method_20758(false, server);
            source.method_9226(() -> class_2561.method_43470((String)"Trader Spawning disabled"), true);
            server.method_3776(class_1267.field_5801, true);
            source.method_9226(() -> class_2561.method_43470((String)"Difficulty set to Peaceful"), true);
            server.method_30002().method_27910(99999, 0, false, false);
            source.method_9226(() -> class_2561.method_43470((String)"Weather cleared"), true);
            for (class_3218 level : server.method_3738()) {
                level.method_29199(1000L);
            }
            source.method_9226(() -> class_2561.method_43470((String)"Set the time to Daytime"), true);
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(BalmCommands.requireAnyPermission(PERMISSION_BALM_EXPORT_CONFIG, PERMISSION_BALM_EXPORT_ICONS))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(BalmCommands.requirePermission(PERMISSION_BALM_EXPORT_CONFIG))).then(class_2170.method_9244((String)"class", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String className = (String)context.getArgument("class", String.class);
            try {
                Class<?> configDataClass = Class.forName(className);
                ConfigJsonExport.exportToFile(configDataClass, new File("exports/config/" + configDataClass.getSimpleName() + ".json"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Invalid config data class: " + className, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error exporting config data class: " + className, e);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Exported config for " + className)), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"icons").requires(BalmCommands.requirePermission(PERMISSION_BALM_EXPORT_ICONS))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String filter = (String)context.getArgument("filter", String.class);
            if (Balm.getProxy().isClient()) {
                try {
                    IconExport.export(filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error exporting icons for " + filter, e);
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Exported icons for " + filter)), false);
                return 1;
            }
            return 0;
        })))));
    }
}

